@echo off
setlocal

REM Zielordner im Benutzerprofil
set TARGET=%LOCALAPPDATA%\RustDeskPortable
set EXE=%TARGET%\rustdesk.exe
set ICON=%TARGET%\hilfe.ico
set LINK=%USERPROFILE%\Desktop\Hilfe F. Suhr.lnk
set SELF=%~f0

REM Prüfen, ob wir schon im Zielordner laufen
if /i not "%~dp0"=="%TARGET%\" (
  echo Installer-Modus: Kopiere Dateien nach %TARGET% ...
  if not exist "%TARGET%" mkdir "%TARGET%"
  copy /Y "%SELF%" "%TARGET%\HilfeSuhr.bat" >nul
  if exist "%~dp0hilfe.ico" copy /Y "%~dp0hilfe.ico" "%ICON%" >nul
  if exist "%~dp0RustDesk2.toml" copy /Y "%~dp0RustDesk2.toml" "%TARGET%\RustDesk2.toml" >nul

  REM Desktop-Verknüpfung anlegen, falls nicht vorhanden
  if not exist "%LINK%" (
    echo Erstelle Desktop-Verknuepfung...
    powershell -NoProfile -ExecutionPolicy Bypass -Command "$ws = New-Object -ComObject WScript.Shell; $s = $ws.CreateShortcut('%LINK%'); $s.TargetPath = '%TARGET%\HilfeSuhr.bat'; $s.IconLocation = '%ICON%'; $s.WorkingDirectory = '%TARGET%'; $s.Save()"
  )

  echo Starte Launcher im Zielordner...
  start "" "%TARGET%\HilfeSuhr.bat"
  exit
)

REM -----------------------------
REM Ab hier: Launcher-Modus
REM -----------------------------

echo Launcher-Modus: Update-Check und Start...

REM Seed-Konfiguration nur beim ersten Mal kopieren
if not exist "%TARGET%\RustDesk2.toml" (
    if exist "%~dp0RustDesk2.toml" (
        echo Kopiere Seed-Konfiguration...
        copy "%~dp0RustDesk2.toml" "%TARGET%\RustDesk2.toml" >nul
    )
)

REM Host-ID, Passwort, Server, Relay, Public Key
set HOSTID=261824696
set HOSTPW=Support123!
set SERVER=help.suhr.dev
set RELAY=help.suhr.dev
set PUBKEY=jjbnFo5LkSsk77OXdYgTLriPWhBkxYtXLDSrZ9QpLRA=


REM Lokale Version ermitteln (falls vorhanden)
set "LOCALVER=none"
if exist "%EXE%" (
  for /f "tokens=*" %%i in ('"%EXE%" --version 2^>nul') do set "LOCALVER=%%i"
)

REM Neueste Version von GitHub holen
for /f "usebackq tokens=*" %%i in (`powershell -NoProfile -ExecutionPolicy Bypass -Command "(Invoke-RestMethod https://api.github.com/repos/rustdesk/rustdesk/releases/latest).tag_name"`) do set "REMOTEVER=%%i"

echo Lokale Version: %LOCALVER%
echo Neueste Version: %REMOTEVER%

REM Wenn keine EXE oder Version unterschiedlich -> Update
if "%LOCALVER%"=="none" goto update
if not "%LOCALVER%"=="%REMOTEVER%" goto update
goto launch

:update
echo Lade neue Version...
powershell -NoProfile -ExecutionPolicy Bypass -Command "$url = (Invoke-RestMethod https://api.github.com/repos/rustdesk/rustdesk/releases/latest).assets | Where-Object { $_.name -like '*x86_64.exe' } | Select-Object -ExpandProperty browser_download_url -First 1; Invoke-WebRequest $url -OutFile '%EXE%' -UseBasicParsing"

:launch
echo Versuche Verbindung per Parameter...
start "" "%EXE%" %HOSTID% --password %HOSTPW% --relay %RELAY% --api-server %SERVER% --key %PUBKEY%
if %ERRORLEVEL%==0 exit

REM -----------------------------
REM Fallback: Seed-Config in %APPDATA%
REM -----------------------------
set CFG=%APPDATA%\RustDesk\config
if not exist "%CFG%" mkdir "%CFG%"
if not exist "%CFG%\RustDesk2.toml" (
  echo Kopiere Fallback-Konfiguration...
  copy "%~dp0RustDesk2.toml" "%CFG%\RustDesk2.toml" >nul
)

echo Starte RustDesk mit Fallback...
start "" "%EXE%" %HOSTID% --password %HOSTPW%
exit